/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.foundation.render.KineticRenderer;
import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.RenderWork;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class FastRenderDispatcher {
    public static WorldAttached<ConcurrentHashMap.KeySetView<TileEntity, Boolean>> queuedUpdates = new WorldAttached<ConcurrentHashMap.KeySetView>(ConcurrentHashMap::newKeySet);

    public static void enqueueUpdate(TileEntity te) {
        queuedUpdates.get((IWorld)te.func_145831_w()).add(te);
    }

    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        KineticRenderer kineticRenderer = CreateClient.kineticRenderer.get((IWorld)world);
        Entity renderViewEntity = mc.field_175622_Z;
        kineticRenderer.tick(renderViewEntity.func_226277_ct_(), renderViewEntity.func_226278_cu_(), renderViewEntity.func_226281_cx_());
        ConcurrentHashMap.KeySetView<TileEntity, Boolean> map = queuedUpdates.get((IWorld)world);
        map.forEach(te -> {
            map.remove(te);
            kineticRenderer.update(te);
        });
    }

    public static boolean available() {
        return Backend.canUseInstancing();
    }

    public static boolean available(World world) {
        return Backend.canUseInstancing() && Backend.isFlywheelWorld(world);
    }

    public static int getDebugMode() {
        return KineticDebugger.isActive() ? 1 : 0;
    }

    public static void refresh() {
        RenderWork.enqueue(() -> ((WorldRenderer)Minecraft.func_71410_x().field_71438_f).func_72712_a());
    }

    public static void renderLayer(RenderType layer, Matrix4f viewProjection, double cameraX, double cameraY, double cameraZ) {
        if (!Backend.canUseInstancing()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        KineticRenderer kineticRenderer = CreateClient.kineticRenderer.get((IWorld)world);
        layer.func_228547_a_();
        kineticRenderer.render(layer, viewProjection, cameraX, cameraY, cameraZ);
        layer.func_228549_b_();
    }
}

