/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.SuperByteBuffer;

public abstract class CTSpriteShiftEntry
extends SpriteShiftEntry {
    int textureSheetSize;

    public CTSpriteShiftEntry(int sheetSize) {
        this.textureSheetSize = sheetSize;
    }

    public float getTargetU(float localU, int index) {
        float uOffset = index % this.textureSheetSize;
        return this.getTarget().func_94214_a((double)((SuperByteBuffer.getUnInterpolatedU(this.getOriginal(), localU) + uOffset * 16.0f) / (float)this.textureSheetSize));
    }

    public float getTargetV(float localV, int index) {
        float vOffset = index / this.textureSheetSize;
        return this.getTarget().func_94207_b((double)((SuperByteBuffer.getUnInterpolatedV(this.getOriginal(), localV) + vOffset * 16.0f) / (float)this.textureSheetSize));
    }

    public abstract int getTextureIndex(ConnectedTextureBehaviour.CTContext var1);

    public abstract CTSpriteShifter.CTType getType();

    public static class Omnidirectional
    extends CTSpriteShiftEntry {
        public Omnidirectional() {
            super(8);
        }

        @Override
        public int getTextureIndex(ConnectedTextureBehaviour.CTContext context) {
            ConnectedTextureBehaviour.CTContext c = context;
            int tileX = 0;
            int tileY = 0;
            int borders = (!c.up ? 1 : 0) + (!c.down ? 1 : 0) + (!c.left ? 1 : 0) + (!c.right ? 1 : 0);
            if (c.up) {
                ++tileX;
            }
            if (c.down) {
                tileX += 2;
            }
            if (c.left) {
                ++tileY;
            }
            if (c.right) {
                tileY += 2;
            }
            if (borders == 0) {
                if (c.topRight) {
                    ++tileX;
                }
                if (c.topLeft) {
                    tileX += 2;
                }
                if (c.bottomRight) {
                    tileY += 2;
                }
                if (c.bottomLeft) {
                    ++tileY;
                }
            }
            if (borders == 1) {
                if (!c.right && (c.topLeft || c.bottomLeft)) {
                    tileY = 4;
                    tileX = -1 + (c.bottomLeft ? 1 : 0) + (c.topLeft ? 1 : 0) * 2;
                }
                if (!c.left && (c.topRight || c.bottomRight)) {
                    tileY = 5;
                    tileX = -1 + (c.bottomRight ? 1 : 0) + (c.topRight ? 1 : 0) * 2;
                }
                if (!c.down && (c.topLeft || c.topRight)) {
                    tileY = 6;
                    tileX = -1 + (c.topLeft ? 1 : 0) + (c.topRight ? 1 : 0) * 2;
                }
                if (!c.up && (c.bottomLeft || c.bottomRight)) {
                    tileY = 7;
                    tileX = -1 + (c.bottomLeft ? 1 : 0) + (c.bottomRight ? 1 : 0) * 2;
                }
            }
            if (borders == 2 && (c.up && c.left && c.topLeft || c.down && c.left && c.bottomLeft || c.up && c.right && c.topRight || c.down && c.right && c.bottomRight)) {
                tileX += 3;
            }
            return tileX + 8 * tileY;
        }

        @Override
        public CTSpriteShifter.CTType getType() {
            return CTSpriteShifter.CTType.OMNIDIRECTIONAL;
        }
    }

    public static class Cross
    extends CTSpriteShiftEntry {
        public Cross() {
            super(4);
        }

        @Override
        public int getTextureIndex(ConnectedTextureBehaviour.CTContext context) {
            return (context.up ? 1 : 0) + (context.down ? 2 : 0) + (context.left ? 4 : 0) + (context.right ? 8 : 0);
        }

        @Override
        public CTSpriteShifter.CTType getType() {
            return CTSpriteShifter.CTType.CROSS;
        }
    }

    public static class Vertical
    extends CTSpriteShiftEntry {
        public Vertical() {
            super(2);
        }

        @Override
        public int getTextureIndex(ConnectedTextureBehaviour.CTContext context) {
            return (context.up ? 1 : 0) + (context.down ? 2 : 0);
        }

        @Override
        public CTSpriteShifter.CTType getType() {
            return CTSpriteShifter.CTType.VERTICAL;
        }
    }

    public static class Horizontal
    extends CTSpriteShiftEntry {
        public Horizontal() {
            super(2);
        }

        @Override
        public int getTextureIndex(ConnectedTextureBehaviour.CTContext context) {
            return (context.right ? 1 : 0) + (context.left ? 2 : 0);
        }

        @Override
        public CTSpriteShifter.CTType getType() {
            return CTSpriteShifter.CTType.HORIZONTAL;
        }
    }
}

