/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicProcessor;
import com.simibubi.create.content.schematics.client.SchematicEditScreen;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Lang;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchematicItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();

    public SchematicItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static ItemStack create(String schematic, String owner) {
        ItemStack blueprint = AllItems.SCHEMATIC.asStack();
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Deployed", false);
        tag.func_74778_a("Owner", owner);
        tag.func_74778_a("File", schematic);
        tag.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)BlockPos.field_177992_a));
        tag.func_74778_a("Rotation", Rotation.NONE.name());
        tag.func_74778_a("Mirror", Mirror.NONE.name());
        blueprint.func_77982_d(tag);
        SchematicItem.writeSize(blueprint);
        return blueprint;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("File")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + stack.func_77978_p().func_74779_i("File")));
            }
        } else {
            tooltip.add((ITextComponent)Lang.translate("schematic.invalid", new Object[0]).func_240699_a_(TextFormatting.RED));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static void writeSize(ItemStack blueprint) {
        CompoundNBT tag = blueprint.func_77978_p();
        Template t = SchematicItem.loadSchematic(blueprint);
        tag.func_218657_a("Bounds", (INBT)NBTUtil.func_186859_a((BlockPos)t.func_186259_a()));
        blueprint.func_77982_d(tag);
        SchematicInstances.clearHash(blueprint);
    }

    public static PlacementSettings getSettings(ItemStack blueprint) {
        CompoundNBT tag = blueprint.func_77978_p();
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.valueOf((String)tag.func_74779_i("Rotation")));
        settings.func_186214_a(Mirror.valueOf((String)tag.func_74779_i("Mirror")));
        settings.func_215222_a((StructureProcessor)SchematicProcessor.INSTANCE);
        return settings;
    }

    public static Template loadSchematic(ItemStack blueprint) {
        Path file;
        Path dir;
        Template t = new Template();
        String owner = blueprint.func_77978_p().func_74779_i("Owner");
        String schematic = blueprint.func_77978_p().func_74779_i("File");
        if (!schematic.endsWith(".nbt")) {
            return t;
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            dir = Paths.get("schematics", "uploaded").toAbsolutePath();
            file = Paths.get(owner, schematic);
        } else {
            dir = Paths.get("schematics", new String[0]).toAbsolutePath();
            file = Paths.get(schematic, new String[0]);
        }
        Path path = dir.resolve(file).normalize();
        if (!path.startsWith(dir)) {
            return t;
        }
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, StandardOpenOption.READ))));){
            CompoundNBT nbt = CompressedStreamTools.func_152456_a((DataInput)stream, (NBTSizeTracker)new NBTSizeTracker(0x20000000L));
            t.func_186256_b(nbt);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read schematic", (Throwable)e);
        }
        return t;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() != null && !this.onItemUse(context.func_195999_j(), context.func_221531_n())) {
            return super.func_195939_a(context);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!this.onItemUse(playerIn, handIn)) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    private boolean onItemUse(PlayerEntity player, Hand hand) {
        if (!player.func_225608_bj_() || hand != Hand.MAIN_HAND) {
            return false;
        }
        if (!player.func_184586_b(hand).func_77942_o()) {
            return false;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::displayBlueprintScreen);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayBlueprintScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }
}

