/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.logistics.block.funnel.AbstractHorizontalFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VoxelShaper;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BeltFunnelBlock
extends AbstractHorizontalFunnelBlock
implements ISpecialBlockItemRequirement {
    private BlockEntry<? extends FunnelBlock> parent;
    public static final EnumProperty<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);

    public BeltFunnelBlock(BlockEntry<? extends FunnelBlock> parent, AbstractBlock.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.parent = parent;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)Shape.RETRACTED)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)p_206840_1_.func_206894_a(new Property[]{SHAPE}));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return ((Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE))).shaper.get((Direction)state.func_177229_b((Property)HORIZONTAL_FACING));
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (p_220071_4_.getEntity() instanceof ItemEntity && (p_220071_1_.func_177229_b(SHAPE) == Shape.PULLING || p_220071_1_.func_177229_b(SHAPE) == Shape.PUSHING)) {
            return AllShapes.FUNNEL_COLLISION.get(this.getFacing(p_220071_1_));
        }
        return this.func_220053_a(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState stateForPlacement = super.func_196258_a(ctx);
        BlockPos pos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        Direction facing = ctx.func_196000_l().func_176740_k().func_176722_c() ? ctx.func_196000_l() : ctx.func_195992_f();
        BlockState state = (BlockState)stateForPlacement.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)facing);
        boolean sneaking = ctx.func_195999_j() != null && ctx.func_195999_j().func_225608_bj_();
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((IBlockReader)world, pos, facing, !sneaking)));
    }

    public static Shape getShapeForPosition(IBlockReader world, BlockPos pos, Direction facing, boolean extracting) {
        Shape perpendicularState;
        BlockPos posBelow = pos.func_177977_b();
        BlockState stateBelow = world.func_180495_p(posBelow);
        Shape shape = perpendicularState = extracting ? Shape.PUSHING : Shape.PULLING;
        if (!AllBlocks.BELT.has(stateBelow)) {
            return perpendicularState;
        }
        Direction movementFacing = (Direction)stateBelow.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        return movementFacing.func_176740_k() != facing.func_176740_k() ? perpendicularState : Shape.RETRACTED;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.parent.asStack();
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbour, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        Shape currentShape;
        if (!BeltFunnelBlock.isOnValidBelt(state, (IWorldReader)world, pos)) {
            BlockState parentState = this.parent.getDefaultState();
            if (state.func_235903_d_((Property)POWERED).orElse(false).booleanValue()) {
                parentState = (BlockState)parentState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true));
            }
            if (state.func_177229_b(SHAPE) == Shape.PUSHING) {
                parentState = (BlockState)parentState.func_206870_a((Property)FunnelBlock.EXTRACTING, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)parentState.func_206870_a((Property)FunnelBlock.FACING, state.func_177229_b((Property)HORIZONTAL_FACING));
        }
        Shape updatedShape = BeltFunnelBlock.getShapeForPosition((IBlockReader)world, pos, (Direction)state.func_177229_b((Property)HORIZONTAL_FACING), state.func_177229_b(SHAPE) == Shape.PUSHING);
        if (updatedShape == (currentShape = (Shape)((Object)state.func_177229_b(SHAPE)))) {
            return state;
        }
        if (updatedShape == Shape.PUSHING && currentShape == Shape.PULLING) {
            return state;
        }
        if (updatedShape == Shape.RETRACTED && currentShape == Shape.EXTENDED) {
            return state;
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)updatedShape));
    }

    public static boolean isOnValidBelt(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState stateBelow = world.func_180495_p(pos.func_177977_b());
        if (stateBelow.func_177230_c() instanceof BeltBlock) {
            return BeltBlock.canTransportObjects(stateBelow);
        }
        DirectBeltInputBehaviour directBeltInputBehaviour = TileEntityBehaviour.get((IBlockReader)world, pos.func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour == null) {
            return false;
        }
        return directBeltInputBehaviour.canSupportBeltFunnels();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        Shape shape;
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Shape newShape = shape = (Shape)((Object)state.func_177229_b(SHAPE));
        if (shape == Shape.PULLING) {
            newShape = Shape.PUSHING;
        } else if (shape == Shape.PUSHING) {
            newShape = Shape.PULLING;
        } else if (shape == Shape.EXTENDED) {
            newShape = Shape.RETRACTED;
        } else if (shape == Shape.RETRACTED) {
            BlockState belt = world.func_180495_p(context.func_195995_a().func_177977_b());
            newShape = belt.func_177230_c() instanceof BeltBlock && belt.func_177229_b(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? Shape.RETRACTED : Shape.EXTENDED;
        }
        if (newShape == shape) {
            return ActionResultType.SUCCESS;
        }
        world.func_175656_a(context.func_195995_a(), (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)newShape)));
        if (newShape == Shape.EXTENDED) {
            Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            BlockState opposite = world.func_180495_p(context.func_195995_a().func_177972_a(facing));
            if (opposite.func_177230_c() instanceof BeltFunnelBlock && opposite.func_177229_b(SHAPE) == Shape.EXTENDED && opposite.func_177229_b((Property)HORIZONTAL_FACING) == facing.func_176734_d()) {
                AllTriggers.triggerFor(AllTriggers.BELT_FUNNEL_KISS, context.func_195999_j());
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        return ItemRequirement.of(this.parent.getDefaultState());
    }

    public static enum Shape implements IStringSerializable
    {
        RETRACTED(AllShapes.BELT_FUNNEL_RETRACTED),
        EXTENDED(AllShapes.BELT_FUNNEL_EXTENDED),
        PUSHING(AllShapes.BELT_FUNNEL_PERPENDICULAR),
        PULLING(AllShapes.BELT_FUNNEL_PERPENDICULAR);

        VoxelShaper shaper;

        private Shape(VoxelShaper shaper) {
            this.shaper = shaper;
        }

        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

