/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.PumpTileEntity;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class PumpRenderer
extends KineticTileEntityRenderer {
    public PumpRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (!(te instanceof PumpTileEntity)) {
            return;
        }
        PumpTileEntity pump = (PumpTileEntity)te;
        Vector3d rotationOffset = new Vector3d(0.5, 0.875, 0.5);
        BlockState blockState = te.func_195044_w();
        float angle = MathHelper.func_219799_g((float)pump.arrowDirection.getValue(partialTicks), (float)0.0f, (float)90.0f) - 90.0f;
        for (float yRot : new float[]{0.0f, 90.0f}) {
            ms.func_227860_a_();
            SuperByteBuffer arrow = AllBlockPartials.MECHANICAL_PUMP_ARROW.renderOn(blockState);
            Direction direction = (Direction)blockState.func_177229_b((Property)PumpBlock.FACING);
            MatrixStacker.of(ms).centre().rotateY(AngleHelper.horizontalAngle(direction) + 180.0f).rotateX(-AngleHelper.verticalAngle(direction) - 90.0f).unCentre().translate(rotationOffset).rotateY(yRot).rotateZ(angle).translateBack(rotationOffset);
            arrow.light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
            ms.func_227865_b_();
        }
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.MECHANICAL_PUMP_COG.renderOnDirectionalSouth(te.func_195044_w());
    }
}

