/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;

public class BasinCategory
extends CreateRecipeCategory<BasinRecipe> {
    private boolean needsHeating;

    public BasinCategory(boolean needsHeating, IDrawable icon, IDrawable background) {
        super(icon, background);
        this.needsHeating = needsHeating;
    }

    public Class<? extends BasinRecipe> getRecipeClass() {
        return BasinRecipe.class;
    }

    public void setIngredients(BasinRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> itemIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.func_192400_c());
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            itemIngredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllBlocks.BLAZE_BURNER.get()}));
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            itemIngredients.add(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllItems.BLAZE_CAKE.get()}));
        }
        ingredients.setInputIngredients(itemIngredients);
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, BasinRecipe recipe, IIngredients iingredients) {
        int j;
        int i;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        ItemStack itemOutput = recipe.getRollableResultsAsItemStacks().isEmpty() ? ItemStack.field_190927_a : recipe.getRollableResultsAsItemStacks().get(0);
        FluidStack fluidOutput = recipe.getFluidResults().isEmpty() ? FluidStack.EMPTY : (FluidStack)recipe.getFluidResults().get(0);
        NonNullList<FluidIngredient> fluidIngredients = recipe.getFluidIngredients();
        List<Pair<Ingredient, MutableInt>> ingredients = ItemHelper.condenseIngredients(recipe.func_192400_c());
        int size = ingredients.size() + fluidIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int yOffset = 0;
        for (i = 0; i < ingredients.size(); ++i) {
            itemStacks.init(i, true, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19 + yOffset);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            Pair<Ingredient, MutableInt> pair = ingredients.get(i);
            Ingredient ingredient = pair.getFirst();
            MutableInt amount = pair.getSecond();
            for (ItemStack itemStack : ingredient.func_193365_a()) {
                ItemStack stack = itemStack.func_77946_l();
                stack.func_190920_e(amount.getValue().intValue());
                stacks.add(stack);
            }
            itemStacks.set(i, stacks);
        }
        for (j = 0; j < fluidIngredients.size(); ++j) {
            int i2 = i + j;
            fluidStacks.init(j, true, 17 + xOffset + i2 % 3 * 19, 51 - i2 / 3 * 19 + yOffset);
            List<FluidStack> stacks = ((FluidIngredient)fluidIngredients.get(j)).getMatchingFluidStacks();
            fluidStacks.set(j, this.withImprovedVisibility(stacks));
        }
        if (!itemOutput.func_190926_b()) {
            itemStacks.init(i, false, 141, 50 + yOffset);
            itemStacks.set(i, recipe.func_77571_b().getStack());
            yOffset -= 19;
        }
        if (!fluidOutput.isEmpty()) {
            fluidStacks.init(j, false, 142, 51 + yOffset);
            fluidStacks.set(j, this.withImprovedVisibility(fluidOutput));
        }
        BasinCategory.addFluidTooltip(fluidStacks, fluidIngredients, (List<FluidStack>)ImmutableList.of((Object)fluidOutput));
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            itemStacks.init(++i, true, 133, 80);
            itemStacks.set(i, AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            itemStacks.init(++i, true, 152, 80);
            itemStacks.set(i, AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(BasinRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        List<Pair<Ingredient, MutableInt>> actualIngredients = ItemHelper.condenseIngredients(recipe.func_192400_c());
        int size = actualIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        int yOffset = 0;
        for (int i = 0; i < size; ++i) {
            AllGuiTextures.JEI_SLOT.draw(matrixStack, 16 + xOffset + i % 3 * 19, 50 - i / 3 * 19 + yOffset);
        }
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 141, 50 + yOffset);
        AllGuiTextures.JEI_DOWN_ARROW.draw(matrixStack, 136, 32 + yOffset);
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.draw(matrixStack, 81, 58 + (noHeat ? 10 : 30));
        if (!this.needsHeating) {
            return;
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.draw(matrixStack, 4, 80);
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)Lang.translate(requiredHeat.getTranslationKey(), new Object[0]), 9.0f, 86.0f, requiredHeat.getColor());
    }
}

