/*
 * Decompiled with CFR 0.152.
 */
package flash.minechess.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import flash.minechess.client.gui.screen.BoardScreen;
import flash.minechess.client.gui.screen.ColorPickerScreen;
import flash.minechess.util.ScreenHelper;
import flash.minechess.util.chess.Piece;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorSquareWidget
extends Button {
    private static final ResourceLocation PIECES = new ResourceLocation("minechess", "textures/gui/pieces.png");
    private int pieceType;
    private int pieceColor;
    private int file;
    private int rank;
    private boolean lightSquare;
    private boolean highlighted;

    public ColorSquareWidget(int x, int y, boolean lightSquare, int file, int rank) {
        super(x, y, 20, 20, StringTextComponent.field_240750_d_, pressed -> {});
        this.file = file;
        this.rank = rank;
        this.pieceType = 0;
        this.pieceColor = 0;
        this.lightSquare = lightSquare;
    }

    public void setPiece(int piece) {
        this.pieceType = Piece.pieceType(piece);
        this.pieceColor = Piece.colour(piece);
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    private int getColor() {
        return this.highlighted ? (this.lightSquare ? ColorPickerScreen.highlightedColor : ScreenHelper.colorLightness(ColorPickerScreen.highlightedColor, -40)) : (this.lightSquare ? BoardScreen.whiteColor : BoardScreen.blackColor);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ColorSquareWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)this.getColor());
        if (this.pieceType != 0) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(PIECES);
            int colorHEX = this.pieceColor == 8 ? ScreenHelper.colorLightness(BoardScreen.whiteColor, 30) : ScreenHelper.colorLightness(BoardScreen.blackColor, 30);
            int r = (colorHEX & 0xFF0000) >> 16;
            int g = (colorHEX & 0xFF00) >> 8;
            int b = colorHEX & 0xFF;
            RenderSystem.color4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int uOffset = this.pieceType < 4 ? this.pieceType - 1 : this.pieceType - 2;
            ColorSquareWidget.func_238466_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)20, (int)20, (float)(uOffset * 200), (float)0.0f, (int)200, (int)200, (int)1200, (int)200);
        }
    }

    public void func_230930_b_() {
    }

    public void func_230988_a_(SoundHandler handler) {
    }
}

