/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.block.CaveCrystalClusterBlock;
import vazkii.quark.content.world.module.SpiralSpiresModule;
import vazkii.quark.content.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class CaveCrystalBlock
extends QuarkGlassBlock {
    public final float[] colorComponents;
    public final Vector3d colorVector;
    public CaveCrystalClusterBlock cluster;

    public CaveCrystalBlock(String regname, int color, QuarkModule module, MaterialColor materialColor) {
        super(regname, module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)materialColor).func_200948_a(0.3f, 0.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(b -> 11).harvestTool(ToolType.PICKAXE).func_235861_h_().harvestLevel(0).func_200944_c().func_226896_b_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b2};
        this.colorVector = new Vector3d((double)r, (double)g, (double)b2);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.TRANSLUCENT);
    }

    private boolean canGrow(World world, BlockPos pos) {
        if (CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance >= 1 && pos.func_177956_o() < 24 && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            return i < 4;
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.canGrow((World)worldIn, pos) && random.nextInt(CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance) == 0) {
            BlockState down = worldIn.func_180495_p(pos.func_177977_b());
            BlockPos up = pos.func_177984_a();
            worldIn.func_175656_a(up, state);
            if (down.func_177230_c() == SpiralSpiresModule.myalite_crystal && ModuleLoader.INSTANCE.isModuleEnabled(SpiralSpiresModule.class) && SpiralSpiresModule.renewableMyalite) {
                worldIn.func_175656_a(pos, SpiralSpiresModule.myalite_crystal.func_176223_P());
            } else {
                for (Direction d : Direction.values()) {
                    BlockPos offPos = up.func_177972_a(d);
                    if (!worldIn.func_175623_d(offPos) || random.nextInt(3) != 0) continue;
                    worldIn.func_175656_a(offPos, (BlockState)this.cluster.func_176223_P().func_206870_a(CaveCrystalClusterBlock.FACING, (Comparable)d));
                }
            }
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.canGrow(worldIn, pos)) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197608_a, x, y, z, (double)this.colorComponents[0], (double)this.colorComponents[1], (double)this.colorComponents[2]);
        }
        for (int i = 0; i < 4; ++i) {
            double range = 5.0;
            double ox = rand.nextDouble() * range - range / 2.0;
            double oy = rand.nextDouble() * range - range / 2.0;
            double oz = rand.nextDouble() * range - range / 2.0;
            double x = (double)pos.func_177958_n() + 0.5 + ox;
            double y = (double)pos.func_177956_o() + 0.5 + oy;
            double z = (double)pos.func_177952_p() + 0.5 + oz;
            float size = 0.4f + rand.nextFloat() * 0.5f;
            if (rand.nextDouble() < 0.1) {
                double ol = (ox * ox + oy * oy + oz * oz) * -2.0;
                if (ol == 0.0) {
                    ol = 1.0E-4;
                }
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, ox / ol, oy / ol, oz / ol);
            }
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], size), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.colorComponents;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        return this.colorVector;
    }
}

