/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.mobs.client.model.ForgottenHatModel;

public class ForgottenHatItem
extends ArmorItem
implements IQuarkItem {
    private static final String TEXTURE = "quark:textures/misc/forgotten_hat_worn.png";
    private final QuarkModule module;
    private Multimap<Attribute, AttributeModifier> attributes;
    @OnlyIn(value=Dist.CLIENT)
    private BipedModel model;

    public ForgottenHatItem(QuarkModule module) {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.HEAD, new Item.Properties().func_200917_a(1).func_200918_c(0).func_200916_a(ItemGroup.field_78040_i).func_208103_a(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)"forgotten_hat");
        this.module = module;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.model == null) {
            this.model = new ForgottenHatModel();
        }
        return (A)this.model;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (this.attributes == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            UUID uuid = UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150");
            builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233828_k_, (Object)new AttributeModifier(uuid, "Armor luck modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(uuid, "Armor reach modifier", 2.0, AttributeModifier.Operation.ADDITION));
            this.attributes = builder.build();
        }
        return slot == this.field_77881_a ? this.attributes : super.func_111205_h(slot);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == ItemGroup.field_78027_g) {
            super.func_150895_a(group, items);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.module != null && this.module.enabled;
    }
}

