/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.addons.oddities.client.screen.MatrixEnchantingPieceList;
import vazkii.quark.addons.oddities.client.screen.MatrixEnchantingPlusButton;
import vazkii.quark.addons.oddities.container.EnchantmentMatrix;
import vazkii.quark.addons.oddities.container.MatrixEnchantingContainer;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.addons.oddities.tile.MatrixEnchantingTableTileEntity;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.MatrixEnchanterOperationMessage;

public class MatrixEnchantingScreen
extends ContainerScreen<MatrixEnchantingContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("quark", "textures/misc/matrix_enchanting.png");
    protected final PlayerInventory playerInv;
    protected final MatrixEnchantingTableTileEntity enchanter;
    protected Button plusButton;
    protected MatrixEnchantingPieceList pieceList;
    protected EnchantmentMatrix.Piece hoveredPiece;
    protected int selectedPiece = -1;
    protected int gridHoverX;
    protected int gridHoverY;
    protected List<Integer> listPieces = null;

    public MatrixEnchantingScreen(MatrixEnchantingContainer container, PlayerInventory inventory, ITextComponent component) {
        super((Container)container, inventory, component);
        this.playerInv = inventory;
        this.enchanter = container.enchanter;
    }

    public void func_231158_b_(Minecraft mc, int x, int y) {
        super.func_231158_b_(mc, x, y);
        this.selectedPiece = -1;
        this.plusButton = new MatrixEnchantingPlusButton(this.field_147003_i + 86, this.field_147009_r + 63, this::add);
        this.func_230480_a_((Widget)this.plusButton);
        this.pieceList = new MatrixEnchantingPieceList(this, 28, 64, this.field_147009_r + 11, this.field_147009_r + 75, 22);
        this.pieceList.func_230959_g_(this.field_147003_i + 139);
        this.field_230705_e_.add(this.pieceList);
        this.updateButtonStatus();
        this.pieceList.refresh();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateButtonStatus();
        if (this.enchanter.matrix == null) {
            this.selectedPiece = -1;
            this.pieceList.refresh();
        }
        if (this.enchanter.clientMatrixDirty) {
            this.pieceList.refresh();
            this.enchanter.clientMatrixDirty = false;
        }
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = this.getMinecraft();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.enchanter.charge > 0 && MatrixEnchantingModule.chargePerLapis > 0) {
            int maxHeight = 18;
            int barHeight = (int)((float)this.enchanter.charge / (float)MatrixEnchantingModule.chargePerLapis * (float)maxHeight);
            this.func_238474_b_(stack, i + 7, j + 32 + maxHeight - barHeight, 50, 176 + maxHeight - barHeight, 4, barHeight);
        }
        this.pieceList.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        if (this.enchanter.matrix != null && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability) && !mc.field_71439_g.func_184812_l_()) {
            int x = i + 74;
            int y = j + 58;
            int xpCost = this.enchanter.matrix.getNewPiecePrice();
            int xpMin = this.enchanter.matrix.getMinXpLevel(this.enchanter.bookshelfPower);
            boolean has = this.enchanter.matrix.validateXp((PlayerEntity)mc.field_71439_g, this.enchanter.bookshelfPower);
            this.func_238474_b_(stack, x, y, 0, this.field_147000_g, 10, 10);
            String text = String.valueOf(xpCost);
            if (!has && mc.field_71439_g.field_71068_ca < xpMin) {
                this.field_230712_o_.func_238405_a_(stack, "!", (float)(x + 6), (float)(y + 3), 0xFF0000);
                text = I18n.func_135052_a((String)"quark.gui.enchanting.min", (Object[])new Object[]{xpMin});
            }
            this.field_230712_o_.func_238421_b_(stack, text, (float)((x -= this.field_230712_o_.func_78256_a(text) - 5) - 1), (float)(y += 3), 0);
            this.field_230712_o_.func_238421_b_(stack, text, (float)(x + 1), (float)y, 0);
            this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)(y + 1), 0);
            this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)(y - 1), 0);
            this.field_230712_o_.func_238421_b_(stack, text, (float)x, (float)y, has ? 0xC8FF8F : 0xFF8F8F);
        }
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.enchanter.func_145748_c_().getString(), 12.0f, 5.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.playerInv.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (this.enchanter.matrix != null) {
            boolean needsRefresh = this.listPieces == null;
            this.listPieces = this.enchanter.matrix.benchedPieces;
            if (needsRefresh) {
                this.pieceList.refresh();
            }
            this.renderMatrixGrid(matrix, this.enchanter.matrix);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        if (this.hoveredPiece != null) {
            EnchantmentMatrix.Piece p;
            int max;
            LinkedList<Object> tooltip = new LinkedList<Object>();
            tooltip.add(new TranslationTextComponent(this.hoveredPiece.enchant.func_200305_d(this.hoveredPiece.level).getString().replaceAll("\\u00A7.", "")).func_240699_a_(TextFormatting.GOLD));
            if (this.hoveredPiece.influence > 0) {
                tooltip.add(new TranslationTextComponent("quark.gui.enchanting.influence", new Object[]{(int)((double)this.hoveredPiece.influence * MatrixEnchantingModule.influencePower * 100.0)}).func_240699_a_(TextFormatting.GRAY));
            }
            if ((max = this.hoveredPiece.getMaxXP()) > 0) {
                tooltip.add(new TranslationTextComponent("quark.gui.enchanting.upgrade", new Object[]{this.hoveredPiece.xp, max}).func_240699_a_(TextFormatting.GRAY));
            }
            if (this.gridHoverX == -1) {
                tooltip.add(new StringTextComponent(""));
                tooltip.add(new TranslationTextComponent("quark.gui.enchanting.left_click").func_240699_a_(TextFormatting.GRAY));
                tooltip.add(new TranslationTextComponent("quark.gui.enchanting.right_click").func_240699_a_(TextFormatting.GRAY));
            } else if (this.selectedPiece != -1 && (p = this.getPiece(this.selectedPiece)) != null && p.enchant == this.hoveredPiece.enchant && this.hoveredPiece.level < this.hoveredPiece.enchant.func_77325_b()) {
                tooltip.add(new StringTextComponent(""));
                tooltip.add(new TranslationTextComponent("quark.gui.enchanting.merge").func_240699_a_(TextFormatting.GRAY));
            }
            this.func_243308_b(stack, tooltip, mouseX, mouseY);
        } else {
            this.func_230459_a_(stack, mouseX, mouseY);
        }
    }

    public void func_212927_b(double mouseX, double mouseY) {
        int gridMouseX = (int)(mouseX - (double)this.field_147003_i - 86.0);
        int gridMouseY = (int)(mouseY - (double)this.field_147009_r - 11.0);
        this.gridHoverX = gridMouseX < 0 ? -1 : gridMouseX / 10;
        int n = this.gridHoverY = gridMouseY < 0 ? -1 : gridMouseY / 10;
        if (this.gridHoverX < 0 || this.gridHoverX > 4 || this.gridHoverY < 0 || this.gridHoverY > 4) {
            this.gridHoverX = -1;
            this.gridHoverY = -1;
            this.hoveredPiece = null;
        } else if (this.enchanter.matrix != null) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            this.hoveredPiece = this.getPiece(hover);
        }
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (this.enchanter.matrix == null) {
            return true;
        }
        if (mouseButton == 0 && this.gridHoverX != -1) {
            int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
            if (this.selectedPiece != -1) {
                if (hover == -1) {
                    this.place(this.selectedPiece, this.gridHoverX, this.gridHoverY);
                } else {
                    this.merge(this.selectedPiece);
                }
            } else {
                this.remove(hover);
                if (!MatrixEnchantingScreen.func_231173_s_()) {
                    this.selectedPiece = hover;
                }
            }
        } else if (mouseButton == 1 && this.selectedPiece != -1) {
            this.rotate(this.selectedPiece);
        }
        return true;
    }

    private void renderMatrixGrid(MatrixStack stack, EnchantmentMatrix matrix) {
        EnchantmentMatrix.Piece piece;
        Minecraft mc = this.getMinecraft();
        mc.func_110434_K().func_110577_a(BACKGROUND);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)86.0f, (float)11.0f, (float)0.0f);
        for (int i : matrix.placedPieces) {
            EnchantmentMatrix.Piece piece2 = this.getPiece(i);
            if (piece2 == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(piece2.x * 10), (float)(piece2.y * 10), (float)0.0f);
            this.renderPiece(stack, piece2, 1.0f);
            RenderSystem.popMatrix();
        }
        if (this.selectedPiece != -1 && this.gridHoverX != -1 && (piece = this.getPiece(this.selectedPiece)) != null && (this.hoveredPiece == null || piece.enchant != this.hoveredPiece.enchant || this.hoveredPiece.level >= this.hoveredPiece.enchant.func_77325_b())) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.gridHoverX * 10), (float)(this.gridHoverY * 10), (float)0.0f);
            float a = 0.2f;
            if (matrix.canPlace(piece, this.gridHoverX, this.gridHoverY)) {
                a = (float)((Math.sin((double)ClientTicker.total * 0.2) + 1.0) * 0.4 + 0.4);
            }
            this.renderPiece(stack, piece, a);
            RenderSystem.popMatrix();
        }
        if (this.hoveredPiece == null && this.gridHoverX != -1) {
            this.renderHover(stack, this.gridHoverX, this.gridHoverY);
        }
        RenderSystem.popMatrix();
    }

    protected void renderPiece(MatrixStack stack, EnchantmentMatrix.Piece piece, float a) {
        float r = (float)(piece.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(piece.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(piece.color & 0xFF) / 255.0f;
        boolean hovered = this.hoveredPiece == piece;
        for (int[] block : piece.blocks) {
            this.renderBlock(stack, block[0], block[1], piece.type, r, g, b, a, hovered);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBlock(MatrixStack stack, int x, int y, int type, float r, float g, float b, float a, boolean hovered) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        this.func_238474_b_(stack, x * 10, y * 10, 11 + type * 10, this.field_147000_g, 10, 10);
        if (hovered) {
            this.renderHover(stack, x, y);
        }
    }

    private void renderHover(MatrixStack stack, int x, int y) {
        MatrixEnchantingScreen.func_238467_a_((MatrixStack)stack, (int)(x * 10), (int)(y * 10), (int)(x * 10 + 10), (int)(y * 10 + 10), (int)0x66FFFFFF);
    }

    public void add(Button button) {
        this.send(0, 0, 0, 0);
    }

    public void place(int id, int x, int y) {
        this.send(1, id, x, y);
        this.selectedPiece = -1;
        this.click();
    }

    public void remove(int id) {
        this.send(2, id, 0, 0);
    }

    public void rotate(int id) {
        this.send(3, id, 0, 0);
    }

    public void merge(int id) {
        int hover = this.enchanter.matrix.matrix[this.gridHoverX][this.gridHoverY];
        EnchantmentMatrix.Piece p = this.getPiece(hover);
        EnchantmentMatrix.Piece p1 = this.getPiece(this.selectedPiece);
        if (p != null && p1 != null && p.enchant == p1.enchant && p.level < p.enchant.func_77325_b()) {
            this.send(4, hover, id, 0);
            this.selectedPiece = -1;
            this.click();
        }
    }

    private void send(int operation, int arg0, int arg1, int arg2) {
        MatrixEnchanterOperationMessage message = new MatrixEnchanterOperationMessage(operation, arg0, arg1, arg2);
        QuarkNetwork.sendToServer(message);
    }

    private void click() {
        this.getMinecraft().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private void updateButtonStatus() {
        this.plusButton.field_230693_o_ = this.enchanter.matrix != null && (this.getMinecraft().field_71439_g.func_184812_l_() || this.enchanter.charge > 0) && this.enchanter.matrix.validateXp((PlayerEntity)this.getMinecraft().field_71439_g, this.enchanter.bookshelfPower) && this.enchanter.matrix.canGeneratePiece(this.enchanter.bookshelfPower, this.enchanter.enchantability);
    }

    protected EnchantmentMatrix.Piece getPiece(int id) {
        EnchantmentMatrix matrix = this.enchanter.matrix;
        if (matrix != null) {
            return matrix.pieces.get(id);
        }
        return null;
    }
}

